package chess4j.hash;

import java.util.HashMap;
import java.util.Map;

import chess4j.board.Board;

public class TTable {

	private static TTable tt = new TTable();
	private Map<Integer,TTEntry> map = new HashMap<Integer,TTEntry>();
	
	private TTable() { }
	public static TTable getInstance() {
		return tt;
	}

	public void clear() {
		map.clear();
	}
	
	public TTEntry get(Integer key) {
		return map.get(key);
	}
	
	public void put(Integer key,TTEntry val) {
		map.put(key, val);
	}
	
	public void storeLowerBound(Board board,int depth,int score) {
		int hashCode=board.hashCode();
		TTEntry entry = new TTEntry(TTEntryType.LOWER_BOUND,hashCode,depth,score);
		getInstance().put(getKey(hashCode), entry);
	}
	
	public int getKey(int hashCode) {
		return hashCode & 0xFFFFF;
	}
	
	public int getKey(Board board) {
		return getKey(board.hashCode());
	}
}
